/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import dev.toma.gunsrpg.common.LootStashDetectorHandler;
import dev.toma.gunsrpg.common.item.StashDetectorItem;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_UseStashDetectorPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2S_RequestStashDetectorStatus
extends AbstractNetworkPacket<C2S_RequestStashDetectorStatus> {
    private final StashDetectorItem.StatusEvent event;

    public C2S_RequestStashDetectorStatus() {
        this(null);
    }

    public C2S_RequestStashDetectorStatus(StashDetectorItem.StatusEvent event) {
        this.event = event;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.event);
    }

    @Override
    public C2S_RequestStashDetectorStatus decode(PacketBuffer buffer) {
        return new C2S_RequestStashDetectorStatus((StashDetectorItem.StatusEvent)buffer.func_179257_a(StashDetectorItem.StatusEvent.class));
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        StashDetectorItem.StatusEvent statusEvent = this.event;
        if (statusEvent == StashDetectorItem.StatusEvent.TOGGLE) {
            statusEvent = LootStashDetectorHandler.isUsing(player.func_110124_au()) ? StashDetectorItem.StatusEvent.OFF : StashDetectorItem.StatusEvent.ON;
        }
        switch (statusEvent) {
            case ON: {
                LootStashDetectorHandler.initiateUsing((PlayerEntity)player);
                break;
            }
            case OFF: {
                LootStashDetectorHandler.stopUsing(player.func_110124_au());
            }
        }
        NetworkManager.sendClientPacket(player, new S2C_UseStashDetectorPacket(statusEvent));
    }
}

